/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.memory;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class GroupConversation {
    private final String groupId;
    private String groupName;
    private final UUID ownerUuid;
    private final List<UUID> members;
    private final long createdAt;
    private boolean active;

    public GroupConversation(String groupId, String groupName, UUID ownerUuid) {
        this.groupId = groupId;
        this.groupName = groupName;
        this.ownerUuid = ownerUuid;
        this.members = new ArrayList<UUID>();
        this.members.add(ownerUuid);
        this.createdAt = System.currentTimeMillis();
        this.active = true;
    }

    public GroupConversation(String groupId, String groupName, UUID ownerUuid, List<UUID> members, long createdAt, boolean active) {
        this.groupId = groupId;
        this.groupName = groupName;
        this.ownerUuid = ownerUuid;
        this.members = new ArrayList<UUID>(members);
        this.createdAt = createdAt;
        this.active = active;
    }

    public boolean addMember(UUID playerUuid) {
        if (this.members.contains(playerUuid)) {
            return false;
        }
        return this.members.add(playerUuid);
    }

    public boolean removeMember(UUID playerUuid) {
        if (playerUuid.equals(this.ownerUuid)) {
            return false;
        }
        return this.members.remove(playerUuid);
    }

    public boolean isMember(UUID playerUuid) {
        return this.members.contains(playerUuid);
    }

    public boolean isOwner(UUID playerUuid) {
        return this.ownerUuid.equals(playerUuid);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public UUID getOwnerUuid() {
        return this.ownerUuid;
    }

    public List<UUID> getMembers() {
        return new ArrayList<UUID>(this.members);
    }

    public int getMemberCount() {
        return this.members.size();
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void disband() {
        this.active = false;
    }

    public String toString() {
        return "GroupConversation{id='" + this.groupId + "', name='" + this.groupName + "', owner=" + String.valueOf(this.ownerUuid) + ", members=" + this.members.size() + ", active=" + this.active + "}";
    }
}

