/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.memory;

import com.nexvor.Nexvor;
import com.nexvor.ai.models.ChatMessage;
import com.nexvor.memory.DatabaseManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class GlobalChatManager {
    private final Nexvor plugin;
    private final DatabaseManager databaseManager;
    private final String GLOBAL_CONVERSATION_ID = "global";
    private final boolean includePlayerNames;
    private final int maxContextMessages;

    public GlobalChatManager(Nexvor plugin, DatabaseManager databaseManager) {
        this.plugin = plugin;
        this.databaseManager = databaseManager;
        this.includePlayerNames = plugin.getConfigManager().isGlobalChatIncludePlayerNames();
        this.maxContextMessages = plugin.getConfigManager().getGlobalChatMaxMessages();
    }

    public void savePlayerMessage(UUID playerUuid, String playerName, String message) {
        String content = this.includePlayerNames ? "[" + playerName + "] " + message : message;
        this.saveMessage(playerUuid, "user", content);
    }

    public void saveAIResponse(String response) {
        this.saveMessage(null, "assistant", response);
    }

    private void saveMessage(UUID playerUuid, String role, String content) {
        String insert = "INSERT INTO global_messages (conversation_id, player_uuid, role, content, timestamp) VALUES (?, ?, ?, ?, ?)";
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(insert);){
            stmt.setString(1, "global");
            stmt.setString(2, playerUuid != null ? playerUuid.toString() : null);
            stmt.setString(3, role);
            stmt.setString(4, content);
            stmt.setLong(5, System.currentTimeMillis());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getNexvorLogger().error("Failed to save global message", e);
        }
    }

    public List<ChatMessage> getContext() {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        String query = "SELECT role, content FROM global_messages\nWHERE conversation_id = ?\nORDER BY timestamp DESC\nLIMIT ?\n";
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(query);){
            stmt.setString(1, "global");
            stmt.setInt(2, this.maxContextMessages);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                messages.add(new ChatMessage(rs.getString("role"), rs.getString("content")));
            }
            Collections.reverse(messages);
        }
        catch (SQLException e) {
            this.plugin.getNexvorLogger().error("Failed to get global context", e);
        }
        return messages;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean clearHistory() {
        String delete = "DELETE FROM global_messages WHERE conversation_id = ?";
        try (Connection conn = this.databaseManager.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement(delete);
                try {
                    stmt.setString(1, "global");
                    int rows = stmt.executeUpdate();
                    this.plugin.getNexvorLogger().info("Cleared " + rows + " messages from global conversation");
                    bl = true;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.plugin.getNexvorLogger().error("Failed to clear global history", e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getMessageCount() {
        String query = "SELECT COUNT(*) as count FROM global_messages WHERE conversation_id = ?";
        try (Connection conn = this.databaseManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(query);){
            stmt.setString(1, "global");
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return 0;
            int n = rs.getInt("count");
            return n;
        }
        catch (SQLException e) {
            this.plugin.getNexvorLogger().error("Failed to get message count", e);
        }
        return 0;
    }
}

