/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.integrations;

import com.nexvor.Nexvor;
import com.nexvor.core.NexvorLogger;
import com.nexvor.integrations.PlaceholderAPIHook;
import org.bukkit.Bukkit;

public class IntegrationManager {
    private final Nexvor plugin;
    private final NexvorLogger logger;
    private boolean placeholderAPIEnabled = false;
    private boolean discordSRVEnabled = false;

    public IntegrationManager(Nexvor plugin) {
        this.plugin = plugin;
        this.logger = plugin.getNexvorLogger();
    }

    public void initialize() {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                PlaceholderAPIHook hook = new PlaceholderAPIHook(this.plugin);
                if (hook.register()) {
                    this.placeholderAPIEnabled = true;
                    this.logger.info("PlaceholderAPI integration enabled");
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to hook into PlaceholderAPI: " + e.getMessage());
            }
        }
        if (Bukkit.getPluginManager().getPlugin("DiscordSRV") != null) {
            this.discordSRVEnabled = true;
            this.logger.info("DiscordSRV detected (integration not yet implemented)");
        }
        if (!this.placeholderAPIEnabled && !this.discordSRVEnabled) {
            this.logger.info("No optional integrations detected");
        }
    }

    public boolean isPlaceholderAPIEnabled() {
        return this.placeholderAPIEnabled;
    }

    public boolean isDiscordSRVEnabled() {
        return this.discordSRVEnabled;
    }
}

