/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.filter;

import com.nexvor.Nexvor;
import com.nexvor.core.NexvorLogger;
import com.nexvor.filter.FilterPreset;
import com.nexvor.filter.FilterResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class LanguageFilter {
    private final Nexvor plugin;
    private final NexvorLogger logger;
    private final boolean enabled;
    private final FilterPreset preset;
    private final Set<String> customWords;
    private final Set<Pattern> wordPatterns;
    private static final Set<String> EXTREME_WORDS = Set.of("fuck", "shit", "bitch", "asshole", "cunt", "damn");
    private static final Set<String> COMMON_WORDS = Set.of("fuck", "shit", "bitch", "asshole", "cunt", "damn", "bastard", "dick", "cock", "pussy", "ass", "hell", "piss", "slut", "whore", "fag", "retard");
    private static final Set<String> STRICT_WORDS = Set.of("fuck", "shit", "bitch", "asshole", "cunt", "damn", "bastard", "dick", "cock", "pussy", "ass", "hell", "piss", "slut", "whore", "fag", "retard", "crap", "suck", "stupid", "idiot", "dumb", "moron", "hate", "kill", "die", "kys", "stfu");

    public LanguageFilter(Nexvor plugin) {
        this.plugin = plugin;
        this.logger = plugin.getNexvorLogger();
        this.enabled = plugin.getConfig().getBoolean("language_filter.enabled", true);
        String presetName = plugin.getConfig().getString("language_filter.preset", "moderate");
        this.preset = FilterPreset.fromString(presetName);
        List customWordsList = plugin.getConfig().getStringList("language_filter.custom_words");
        this.customWords = customWordsList.stream().map(String::toLowerCase).collect(Collectors.toSet());
        this.wordPatterns = new HashSet<Pattern>();
        this.compileWordPatterns();
        this.logger.info("Language filter initialized: " + (this.enabled ? "ENABLED" : "DISABLED") + " (preset: " + String.valueOf((Object)this.preset) + ", custom words: " + this.customWords.size() + ")");
    }

    private void compileWordPatterns() {
        Set<String> wordsToFilter = this.getFilteredWords();
        for (String word : wordsToFilter) {
            String regex = "\\b" + Pattern.quote(word) + "\\b";
            this.wordPatterns.add(Pattern.compile(regex, 2));
        }
    }

    private Set<String> getFilteredWords() {
        HashSet<String> words = new HashSet<String>();
        switch (this.preset) {
            case OFF: {
                break;
            }
            case MILD: {
                words.addAll(EXTREME_WORDS);
                break;
            }
            case MODERATE: {
                words.addAll(COMMON_WORDS);
                break;
            }
            case STRICT: {
                words.addAll(STRICT_WORDS);
            }
        }
        words.addAll(this.customWords);
        return words;
    }

    public FilterResult check(String text) {
        if (!this.enabled) {
            return FilterResult.allowed();
        }
        if (text == null || text.isEmpty()) {
            return FilterResult.allowed();
        }
        ArrayList<String> matchedWords = new ArrayList<String>();
        for (Pattern pattern : this.wordPatterns) {
            if (!pattern.matcher(text).find()) continue;
            String matchedWord = pattern.pattern().replace("\\b", "").replace("\\Q", "").replace("\\E", "");
            matchedWords.add(matchedWord);
        }
        if (matchedWords.isEmpty()) {
            return FilterResult.allowed();
        }
        this.logger.debug("Filtered text contains inappropriate content: " + String.valueOf(matchedWords));
        return FilterResult.blocked(matchedWords);
    }

    public String sanitize(String text) {
        if (!this.enabled || text == null) {
            return text;
        }
        String sanitized = text;
        for (Pattern pattern : this.wordPatterns) {
            sanitized = pattern.matcher(sanitized).replaceAll(match -> {
                String word = match.group();
                return "*".repeat(word.length());
            });
        }
        return sanitized;
    }

    public void reload() {
        this.wordPatterns.clear();
        List customWordsList = this.plugin.getConfig().getStringList("language_filter.custom_words");
        this.customWords.clear();
        this.customWords.addAll(customWordsList.stream().map(String::toLowerCase).collect(Collectors.toSet()));
        this.compileWordPatterns();
        this.logger.info("Language filter reloaded: " + this.wordPatterns.size() + " word patterns");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public FilterPreset getPreset() {
        return this.preset;
    }

    public int getCustomWordCount() {
        return this.customWords.size();
    }
}

