/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.core;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.plugin.java.JavaPlugin;

public class NexvorLogger {
    private final Logger logger;
    private final String prefix = "[Nexvor] ";

    public NexvorLogger(JavaPlugin plugin) {
        this.logger = plugin.getLogger();
    }

    public void info(String message) {
        this.logger.info(this.sanitize(message));
    }

    public void warn(String message) {
        this.logger.warning(this.sanitize(message));
    }

    public void severe(String message) {
        this.logger.severe(this.sanitize(message));
    }

    public void debug(String message) {
        this.logger.log(Level.FINE, this.sanitize(message));
    }

    public void error(String message, Throwable throwable) {
        this.logger.log(Level.SEVERE, this.sanitize(message), throwable);
    }

    private String sanitize(String message) {
        if (message == null) {
            return "";
        }
        String sanitized = message.replaceAll("sk-[a-zA-Z0-9]{32,}", "sk-***REDACTED***");
        sanitized = sanitized.replaceAll("Bearer [a-zA-Z0-9-._~+/]+=*", "Bearer ***REDACTED***");
        sanitized = sanitized.replaceAll("[A-Za-z0-9_-]{24}\\.[A-Za-z0-9_-]{6}\\.[A-Za-z0-9_-]{27}", "***DISCORD_TOKEN***");
        return sanitized;
    }
}

