/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.core;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.nexvor.Nexvor;
import com.nexvor.core.LicenseResponse;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public class LicenseValidator {
    private final Nexvor plugin;
    private final HttpClient httpClient;
    private final Gson gson;
    private final String validationUrl;
    private LicenseResponse cachedResponse;
    private String cachedLicenseKey;
    private long cacheTimestamp;
    private static final long CACHE_DURATION_MS = 3600000L;

    public LicenseValidator(Nexvor plugin, String validationUrl) {
        this.plugin = plugin;
        this.validationUrl = validationUrl;
        this.gson = new Gson();
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    }

    public CompletableFuture<LicenseResponse> validateAsync(String licenseKey) {
        if (this.isCacheValid(licenseKey)) {
            this.plugin.getNexvorLogger().info("Using cached license validation result");
            return CompletableFuture.completedFuture(this.cachedResponse);
        }
        try {
            JsonObject requestBody = new JsonObject();
            requestBody.addProperty("licenseKey", licenseKey);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.validationUrl)).header("Content-Type", "application/json").header("User-Agent", "Nexvor/" + this.plugin.getDescription().getVersion()).POST(HttpRequest.BodyPublishers.ofString(this.gson.toJson(requestBody))).timeout(Duration.ofSeconds(15L)).build();
            return ((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
                if (response.statusCode() == 200) {
                    try {
                        LicenseResponse licenseResponse = this.gson.fromJson((String)response.body(), LicenseResponse.class);
                        this.cacheResponse(licenseKey, licenseResponse);
                        return licenseResponse;
                    }
                    catch (Exception e) {
                        this.plugin.getNexvorLogger().warn("Failed to parse license validation response: " + e.getMessage());
                        return this.createErrorResponse("Invalid response format");
                    }
                }
                this.plugin.getNexvorLogger().warn("License validation failed with status code: " + response.statusCode());
                return this.createErrorResponse("Server returned error: " + response.statusCode());
            })).exceptionally(throwable -> {
                this.plugin.getNexvorLogger().warn("License validation request failed: " + throwable.getMessage());
                return this.createErrorResponse("Network error: " + throwable.getMessage());
            });
        }
        catch (Exception e) {
            this.plugin.getNexvorLogger().warn("Failed to create license validation request: " + e.getMessage());
            return CompletableFuture.completedFuture(this.createErrorResponse("Failed to create request"));
        }
    }

    public LicenseResponse validateSync(String licenseKey) {
        try {
            return this.validateAsync(licenseKey).get();
        }
        catch (Exception e) {
            this.plugin.getNexvorLogger().warn("Synchronous license validation failed: " + e.getMessage());
            return this.createErrorResponse("Validation timeout");
        }
    }

    private boolean isCacheValid(String licenseKey) {
        if (this.cachedResponse == null || this.cachedLicenseKey == null) {
            return false;
        }
        if (!this.cachedLicenseKey.equals(licenseKey)) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        return currentTime - this.cacheTimestamp < 3600000L;
    }

    private void cacheResponse(String licenseKey, LicenseResponse response) {
        this.cachedLicenseKey = licenseKey;
        this.cachedResponse = response;
        this.cacheTimestamp = System.currentTimeMillis();
    }

    public void clearCache() {
        this.cachedLicenseKey = null;
        this.cachedResponse = null;
        this.cacheTimestamp = 0L;
    }

    private LicenseResponse createErrorResponse(String message) {
        LicenseResponse response = new LicenseResponse();
        response.setValid(false);
        response.setTier("BASIC");
        response.setMessage(message);
        return response;
    }

    public void shutdown() {
        this.clearCache();
    }
}

