/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.config;

import com.nexvor.Nexvor;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final Nexvor plugin;
    private final FileConfiguration config;

    public ConfigManager(Nexvor plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
        this.validateConfig();
    }

    private void validateConfig() {
        if (this.getBotName().isEmpty()) {
            this.plugin.getNexvorLogger().warn("Bot name is empty, using default: Nexvor");
        }
        if (this.getApiProvider().isEmpty()) {
            this.plugin.getNexvorLogger().severe("API provider not set in config.yml!");
        }
        if (this.getApiKey().isEmpty() || this.getApiKey().equals("your-api-key-here")) {
            this.plugin.getNexvorLogger().severe("API key not set in config.yml! The bot will not work without a valid API key.");
        }
        if (this.getApiModel().isEmpty()) {
            this.plugin.getNexvorLogger().warn("API model not set, provider default will be used");
        }
        if (this.getRateLimitCooldown() < 0) {
            this.plugin.getNexvorLogger().warn("Rate limit cooldown cannot be negative, using 3 seconds");
        }
        if (this.getRateLimitMaxPerMinute() < 1) {
            this.plugin.getNexvorLogger().warn("Max requests per minute must be at least 1, using 10");
        }
    }

    public String getLicenseKey() {
        return this.config.getString("license.key", "none");
    }

    public String getLicenseValidationUrl() {
        return this.config.getString("license.validation_url", "https://nexvor.dev/api/validate");
    }

    public String getLicenseActivationUrl() {
        return this.config.getString("license.activation_url", "https://nexvor.dev/api/activate");
    }

    public String getBotName() {
        return this.config.getString("bot.name", "Nexvor");
    }

    public boolean isBotEnabled() {
        return this.config.getBoolean("bot.enabled", true);
    }

    public String getPersonalityPreset() {
        return this.config.getString("bot.preset", "helper");
    }

    public String getSystemPrompt() {
        return this.config.getString("bot.system_prompt", "You are Nexvor, a helpful AI assistant in this Minecraft server. Be friendly, concise, and helpful.");
    }

    public String getApiProvider() {
        return this.config.getString("api.provider", "groq");
    }

    public String getApiKey() {
        return this.config.getString("api.api_key", "");
    }

    public String getApiModel() {
        return this.config.getString("api.model", "");
    }

    public String getProviderType(String section) {
        return this.config.getString("api.providers." + section + ".type", null);
    }

    public String getProviderName(String section) {
        return this.config.getString("api.providers." + section + ".name", "Custom");
    }

    public String getProviderApiKey(String section) {
        return this.config.getString("api.providers." + section + ".api_key", "");
    }

    public String getProviderModel(String section) {
        return this.config.getString("api.providers." + section + ".model", "");
    }

    public String getProviderBaseUrl(String section) {
        return this.config.getString("api.providers." + section + ".base_url", null);
    }

    public Map<String, String> getProviderHeaders(String section) {
        ConfigurationSection headersSection;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.config.contains("api.providers." + section + ".headers") && (headersSection = this.config.getConfigurationSection("api.providers." + section + ".headers")) != null) {
            for (String key : headersSection.getKeys(false)) {
                headers.put(key, headersSection.getString(key));
            }
        }
        return headers;
    }

    public boolean isFallbackEnabled() {
        return this.config.getBoolean("api.fallback_enabled", true);
    }

    public boolean isMemoryEnabled() {
        return this.config.getBoolean("memory.enabled", true);
    }

    public int getConversationBufferSize() {
        return this.config.getInt("memory.conversation_buffer_size", 50);
    }

    public String getDatabaseType() {
        return this.config.getString("memory.database", "sqlite");
    }

    public boolean isRateLimitingEnabled() {
        return this.config.getBoolean("rate_limiting.enabled", true);
    }

    public int getRateLimitCooldown() {
        int cooldown = this.config.getInt("rate_limiting.cooldown_seconds", 3);
        return Math.max(0, cooldown);
    }

    public int getRateLimitMaxPerMinute() {
        int max = this.config.getInt("rate_limiting.max_requests_per_minute", 10);
        return Math.max(1, max);
    }

    public boolean isRateLimitIgnoreOps() {
        return this.config.getBoolean("rate_limiting.ignore_ops", true);
    }

    public boolean isIgnoreBots() {
        return this.config.getBoolean("anti_spam.ignore_bots", true);
    }

    public boolean isLanguageFilterEnabled() {
        return this.config.getBoolean("language_filter.enabled", true);
    }

    public String getLanguageFilterPreset() {
        return this.config.getString("language_filter.preset", "moderate");
    }

    public boolean isPlayerOptOutAllowed() {
        return this.config.getBoolean("privacy.allow_player_opt_out", true);
    }

    public boolean isTelemetryEnabled() {
        return this.config.getBoolean("telemetry.enabled", true);
    }

    public boolean isSendToDeveloper() {
        return this.config.getBoolean("telemetry.send_to_developer", false);
    }

    public String getDiscordMode() {
        return this.config.getString("discord.mode", "discordsrv");
    }

    public boolean isPlaceholderApiEnabled() {
        return this.config.getBoolean("integrations.placeholder_api", true);
    }

    public boolean isVaultEnabled() {
        return this.config.getBoolean("integrations.vault", true);
    }

    public boolean isUpdateCheckEnabled() {
        return this.config.getBoolean("updates.check_for_updates", true);
    }

    public String getUpdateUrl() {
        return this.config.getString("updates.update_url", "https://nexvor.dev/api/version");
    }

    public boolean isUpdateAutoDownload() {
        return this.config.getBoolean("updates.auto_download", false);
    }

    public boolean isUpdateNotifyOps() {
        return this.config.getBoolean("updates.notify_ops", true);
    }

    public boolean isGroupConversationsEnabled() {
        return this.config.getBoolean("group_conversations.enabled", true);
    }

    public String getGroupConversationMode() {
        return this.config.getString("group_conversations.mode", "private").toLowerCase();
    }

    public int getGlobalChatMaxMessages() {
        return this.config.getInt("group_conversations.global.max_context_messages", 50);
    }

    public boolean isGlobalChatIncludePlayerNames() {
        return this.config.getBoolean("group_conversations.global.include_player_names", true);
    }

    public double getProximityChatRadius() {
        return this.config.getDouble("group_conversations.proximity.radius", 150.0);
    }

    public boolean isProximityChatAutoManage() {
        return this.config.getBoolean("group_conversations.proximity.auto_manage_groups", true);
    }

    public int getProximityChatUpdateInterval() {
        return this.config.getInt("group_conversations.proximity.update_interval", 100);
    }

    public int getProximityChatMinPlayers() {
        return this.config.getInt("group_conversations.proximity.min_players", 2);
    }

    public boolean isProximityChatIncludePlayerNames() {
        return this.config.getBoolean("group_conversations.proximity.include_player_names", true);
    }

    public void reload() {
        this.plugin.reloadConfig();
    }
}

