/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.commands.subcommands;

import com.nexvor.Nexvor;
import com.nexvor.commands.BaseCommand;
import com.nexvor.updater.UpdateResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;

public class UpdateCommand
extends BaseCommand {
    public UpdateCommand(Nexvor plugin) {
        super(plugin);
    }

    @Override
    public String getName() {
        return "update";
    }

    @Override
    public String getDescription() {
        return "Check for plugin updates";
    }

    @Override
    public String getUsage() {
        return "/nexvor update <check|info|download>";
    }

    @Override
    public String getPermission() {
        return "nexvor.admin";
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        String subCommand;
        if (this.plugin.getUpdateChecker() == null) {
            sender.sendMessage("\u00a7e[Nexvor] \u00a7cUpdate checker is not enabled");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a7e[Nexvor] Update Commands:");
            sender.sendMessage("\u00a77/nexvor update check \u00a7f- Check for updates");
            sender.sendMessage("\u00a77/nexvor update info \u00a7f- Show update information");
            sender.sendMessage("\u00a77/nexvor update download \u00a7f- Download latest update");
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "check": {
                this.handleCheckCommand(sender);
                break;
            }
            case "info": {
                this.handleInfoCommand(sender);
                break;
            }
            case "download": {
                this.handleDownloadCommand(sender);
                break;
            }
            default: {
                sender.sendMessage("\u00a7e[Nexvor] \u00a7cUnknown subcommand: " + subCommand);
                sender.sendMessage("\u00a77Use \u00a7f/nexvor update \u00a77for help");
            }
        }
        return true;
    }

    private void handleCheckCommand(CommandSender sender) {
        sender.sendMessage("\u00a7e[Nexvor] \u00a77Checking for updates...");
        this.plugin.getUpdateChecker().checkForUpdatesAsync().thenAccept(response -> {
            String currentVersion = this.plugin.getUpdateChecker().getCurrentVersion();
            if (response.isUpdateAvailable(currentVersion)) {
                sender.sendMessage("\u00a7e[Nexvor] \u00a7aUpdate available: \u00a7fv" + response.getLatestVersion() + " \u00a77(current: v" + currentVersion + ")");
                if (response.isCritical()) {
                    sender.sendMessage("\u00a7e[Nexvor] \u00a7c\u26a0 This is a CRITICAL update!");
                }
                sender.sendMessage("\u00a77Use \u00a7f/nexvor update info \u00a77for details");
                sender.sendMessage("\u00a77Use \u00a7f/nexvor update download \u00a77to download");
            } else {
                sender.sendMessage("\u00a7e[Nexvor] \u00a7aYou are running the latest version (v" + currentVersion + ")");
            }
        });
    }

    private void handleInfoCommand(CommandSender sender) {
        UpdateResponse update = this.plugin.getUpdateChecker().getLatestUpdate();
        if (update == null) {
            sender.sendMessage("\u00a7e[Nexvor] \u00a7cNo update information available");
            sender.sendMessage("\u00a77Use \u00a7f/nexvor update check \u00a77first");
            return;
        }
        String currentVersion = this.plugin.getUpdateChecker().getCurrentVersion();
        sender.sendMessage("\u00a7e[Nexvor] Update Information:");
        sender.sendMessage("\u00a77Current Version: \u00a7fv" + currentVersion);
        sender.sendMessage("\u00a77Latest Version: \u00a7fv" + update.getLatestVersion());
        if (update.isUpdateAvailable(currentVersion)) {
            sender.sendMessage("\u00a77Status: \u00a7aUpdate Available");
            if (update.isCritical()) {
                sender.sendMessage("\u00a77Priority: \u00a7cCRITICAL");
            }
            if (update.getChangelog() != null && !update.getChangelog().isEmpty()) {
                String[] lines;
                sender.sendMessage("\u00a77Changelog:");
                for (String line : lines = update.getChangelog().split("\\n")) {
                    sender.sendMessage("\u00a77  " + line);
                }
            }
            if (update.getMinMinecraftVersion() != null) {
                sender.sendMessage("\u00a77Min Minecraft: \u00a7f" + update.getMinMinecraftVersion());
            }
            sender.sendMessage("\u00a77Download: \u00a7f/nexvor update download");
        } else {
            sender.sendMessage("\u00a77Status: \u00a7aUp to Date");
        }
    }

    private void handleDownloadCommand(CommandSender sender) {
        UpdateResponse update = this.plugin.getUpdateChecker().getLatestUpdate();
        String currentVersion = this.plugin.getUpdateChecker().getCurrentVersion();
        if (update == null || !update.isUpdateAvailable(currentVersion)) {
            sender.sendMessage("\u00a7e[Nexvor] \u00a7cNo update available");
            sender.sendMessage("\u00a77Use \u00a7f/nexvor update check \u00a77to check for updates");
            return;
        }
        sender.sendMessage("\u00a7e[Nexvor] \u00a77Downloading update v" + update.getLatestVersion() + "...");
        sender.sendMessage("\u00a77This may take a moment...");
        this.plugin.getUpdateChecker().downloadUpdateAsync().thenAccept(success -> {
            if (success.booleanValue()) {
                sender.sendMessage("\u00a7e[Nexvor] \u00a7aUpdate downloaded successfully!");
                sender.sendMessage("\u00a7e[Nexvor] \u00a77The update has been placed in \u00a7fplugins/updates/");
                sender.sendMessage("\u00a7e[Nexvor] \u00a7c\u26a0 Restart your server to apply the update");
            } else {
                sender.sendMessage("\u00a7e[Nexvor] \u00a7cFailed to download update");
                sender.sendMessage("\u00a77Please download manually from: " + update.getDownloadUrl());
            }
        });
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return this.filterStartsWith(Arrays.asList("check", "info", "download"), args[0]);
        }
        return new ArrayList<String>();
    }

    private List<String> filterStartsWith(List<String> list, String prefix) {
        ArrayList<String> filtered = new ArrayList<String>();
        String lowerPrefix = prefix.toLowerCase();
        for (String item : list) {
            if (!item.toLowerCase().startsWith(lowerPrefix)) continue;
            filtered.add(item);
        }
        return filtered;
    }
}

