/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.commands.subcommands;

import com.nexvor.Nexvor;
import com.nexvor.commands.BaseCommand;
import org.bukkit.command.CommandSender;

public class ReloadCommand
extends BaseCommand {
    public ReloadCommand(Nexvor plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        this.sendMessage(sender, "Reloading Nexvor configuration...");
        try {
            this.plugin.reload();
            this.sendSuccess(sender, "Configuration reloaded successfully!");
            this.sendMessage(sender, "\u00a77Active tier: \u00a7f" + this.plugin.getActiveTier().getDisplayName());
            if (this.plugin.getAIProvider() == null) {
                this.sendError(sender, "Warning: AI provider failed to initialize! Check server logs.");
            } else {
                this.sendSuccess(sender, "AI provider: " + this.plugin.getAIProvider().getProviderName());
            }
        }
        catch (Exception e) {
            this.sendError(sender, "Failed to reload configuration!");
            this.plugin.getNexvorLogger().error("Reload failed", e);
        }
        return true;
    }

    @Override
    public String getName() {
        return "reload";
    }

    @Override
    public String getDescription() {
        return "Reload the plugin configuration";
    }

    @Override
    public String getUsage() {
        return "/nexvor reload";
    }

    @Override
    public String getPermission() {
        return "nexvor.reload";
    }
}

