/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.commands;

import com.nexvor.Nexvor;
import com.nexvor.commands.BaseCommand;
import com.nexvor.commands.subcommands.ChatCommand;
import com.nexvor.commands.subcommands.EventsCommand;
import com.nexvor.commands.subcommands.ForgetCommand;
import com.nexvor.commands.subcommands.GroupCommand;
import com.nexvor.commands.subcommands.HelpCommand;
import com.nexvor.commands.subcommands.PrivacyCommand;
import com.nexvor.commands.subcommands.ReloadCommand;
import com.nexvor.commands.subcommands.UpdateCommand;
import com.nexvor.core.PluginTier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class NexvorCommand
implements CommandExecutor,
TabCompleter {
    private final Nexvor plugin;
    private final Map<String, BaseCommand> subcommands;

    public NexvorCommand(Nexvor plugin) {
        this.plugin = plugin;
        this.subcommands = new HashMap<String, BaseCommand>();
        this.registerSubcommand(new ChatCommand(plugin));
        this.registerSubcommand(new HelpCommand(plugin, this));
        this.registerSubcommand(new ReloadCommand(plugin));
        this.registerSubcommand(new ForgetCommand(plugin));
        this.registerSubcommand(new PrivacyCommand(plugin));
        this.registerSubcommand(new UpdateCommand(plugin));
        if (plugin.hasTier(PluginTier.MEDIUM)) {
            this.registerSubcommand(new GroupCommand(plugin));
            this.registerSubcommand(new EventsCommand(plugin));
        }
    }

    private void registerSubcommand(BaseCommand command) {
        this.subcommands.put(command.getName().toLowerCase(), command);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            BaseCommand helpCommand = this.subcommands.get("help");
            if (helpCommand != null) {
                return helpCommand.execute(sender, new String[0]);
            }
            return true;
        }
        String subcommandName = args[0].toLowerCase();
        BaseCommand subcommand = this.subcommands.get(subcommandName);
        if (subcommand == null) {
            sender.sendMessage("\u00a77[\u00a7bNexvor\u00a77] \u00a7cUnknown command: " + subcommandName);
            sender.sendMessage("\u00a77Use \u00a7f/nexvor help \u00a77for available commands");
            return true;
        }
        if (!subcommand.hasPermission(sender)) {
            sender.sendMessage("\u00a77[\u00a7bNexvor\u00a77] \u00a7cYou don't have permission to use this command!");
            return true;
        }
        String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
        boolean success = subcommand.execute(sender, subArgs);
        if (!success) {
            sender.sendMessage("\u00a77[\u00a7bNexvor\u00a77] \u00a7cUsage: " + subcommand.getUsage());
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String subcommandName;
        BaseCommand subcommand;
        List<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            for (BaseCommand subcommand2 : this.subcommands.values()) {
                String name;
                if (!subcommand2.hasPermission(sender) || !(name = subcommand2.getName()).toLowerCase().startsWith(args[0].toLowerCase())) continue;
                completions.add(name);
            }
        } else if (args.length > 1 && (subcommand = this.subcommands.get(subcommandName = args[0].toLowerCase())) != null && subcommand.hasPermission(sender)) {
            String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
            completions = subcommand.tabComplete(sender, subArgs);
        }
        return completions;
    }

    public Collection<BaseCommand> getSubcommands() {
        return this.subcommands.values();
    }
}

