/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.ai.providers;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nexvor.Nexvor;
import com.nexvor.ai.AIProvider;
import com.nexvor.ai.APIClient;
import com.nexvor.ai.models.ChatMessage;
import com.nexvor.ai.models.ChatRequest;
import com.nexvor.ai.models.ChatResponse;
import java.util.concurrent.CompletableFuture;

public class GroqProvider
implements AIProvider {
    private static final String API_URL = "https://api.groq.com/openai/v1/chat/completions";
    private static final String DEFAULT_MODEL = "llama-3.3-70b-versatile";
    private final Nexvor plugin;
    private final APIClient apiClient;
    private final String apiKey;
    private final String model;

    public GroqProvider(Nexvor plugin, String apiKey, String model) {
        this.plugin = plugin;
        this.apiClient = new APIClient(plugin);
        this.apiKey = apiKey;
        this.model = model != null && !model.isEmpty() ? model : DEFAULT_MODEL;
    }

    @Override
    public CompletableFuture<ChatResponse> sendRequest(ChatRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String json = this.buildRequestJson(request);
                String responseJson = this.apiClient.postAsync(API_URL, json, this.apiKey).join();
                return this.parseResponse(responseJson);
            }
            catch (Exception e) {
                this.plugin.getNexvorLogger().error("Groq API error: " + e.getMessage(), e);
                return ChatResponse.error("Failed to get response from Groq: " + e.getMessage());
            }
        });
    }

    private String buildRequestJson(ChatRequest request) {
        JsonObject root = new JsonObject();
        root.addProperty("model", request.getModel());
        root.addProperty("temperature", request.getTemperature());
        root.addProperty("max_tokens", request.getMaxTokens());
        JsonArray messages = new JsonArray();
        for (ChatMessage msg : request.getMessages()) {
            JsonObject message = new JsonObject();
            message.addProperty("role", msg.getRole());
            message.addProperty("content", msg.getContent());
            messages.add(message);
        }
        root.add("messages", messages);
        return root.toString();
    }

    private ChatResponse parseResponse(String json) {
        try {
            JsonObject root = JsonParser.parseString(json).getAsJsonObject();
            String content = root.getAsJsonArray("choices").get(0).getAsJsonObject().getAsJsonObject("message").get("content").getAsString();
            JsonObject usage = root.getAsJsonObject("usage");
            int promptTokens = usage.get("prompt_tokens").getAsInt();
            int completionTokens = usage.get("completion_tokens").getAsInt();
            int totalTokens = usage.get("total_tokens").getAsInt();
            String model = root.get("model").getAsString();
            return ChatResponse.builder().content(content).model(model).promptTokens(promptTokens).completionTokens(completionTokens).totalTokens(totalTokens).success(true).build();
        }
        catch (Exception e) {
            this.plugin.getNexvorLogger().error("Failed to parse Groq response: " + e.getMessage(), e);
            return ChatResponse.error("Failed to parse response: " + e.getMessage());
        }
    }

    @Override
    public String getProviderName() {
        return "groq";
    }

    @Override
    public boolean isConfigured() {
        return this.apiKey != null && !this.apiKey.isEmpty() && this.validateApiKey(this.apiKey);
    }

    @Override
    public String getDefaultModel() {
        return this.model;
    }

    @Override
    public boolean validateApiKey(String apiKey) {
        return apiKey != null && apiKey.startsWith("gsk_") && apiKey.length() > 20;
    }

    public void shutdown() {
        this.apiClient.shutdown();
    }
}

