/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.ai.models;

public class ChatResponse {
    private final String content;
    private final String model;
    private final int promptTokens;
    private final int completionTokens;
    private final int totalTokens;
    private final boolean success;
    private final String errorMessage;

    private ChatResponse(Builder builder) {
        this.content = builder.content;
        this.model = builder.model;
        this.promptTokens = builder.promptTokens;
        this.completionTokens = builder.completionTokens;
        this.totalTokens = builder.totalTokens;
        this.success = builder.success;
        this.errorMessage = builder.errorMessage;
    }

    public String getContent() {
        return this.content;
    }

    public String getModel() {
        return this.model;
    }

    public int getPromptTokens() {
        return this.promptTokens;
    }

    public int getCompletionTokens() {
        return this.completionTokens;
    }

    public int getTotalTokens() {
        return this.totalTokens;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ChatResponse success(String content, String model) {
        return ChatResponse.builder().content(content).model(model).success(true).build();
    }

    public static ChatResponse error(String errorMessage) {
        return ChatResponse.builder().success(false).error(errorMessage).build();
    }

    public static class Builder {
        private String content = "";
        private String model = "";
        private int promptTokens = 0;
        private int completionTokens = 0;
        private int totalTokens = 0;
        private boolean success = true;
        private String errorMessage = null;

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder promptTokens(int tokens) {
            this.promptTokens = tokens;
            return this;
        }

        public Builder completionTokens(int tokens) {
            this.completionTokens = tokens;
            return this;
        }

        public Builder totalTokens(int tokens) {
            this.totalTokens = tokens;
            return this;
        }

        public Builder success(boolean success) {
            this.success = success;
            return this;
        }

        public Builder error(String errorMessage) {
            this.success = false;
            this.errorMessage = errorMessage;
            return this;
        }

        public ChatResponse build() {
            return new ChatResponse(this);
        }
    }
}

