/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.ai;

import com.nexvor.Nexvor;
import com.nexvor.ai.AIProvider;
import com.nexvor.ai.models.ChatRequest;
import com.nexvor.ai.models.ChatResponse;
import com.nexvor.ai.providers.CustomProvider;
import com.nexvor.ai.providers.GroqProvider;
import com.nexvor.ai.providers.OpenAIProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class ProviderManager {
    private final Nexvor plugin;
    private final List<AIProvider> providers;
    private final boolean fallbackEnabled;
    private AIProvider primaryProvider;
    private AIProvider fallbackProvider;

    public ProviderManager(Nexvor plugin, AIProvider provider) {
        this.plugin = plugin;
        this.providers = new ArrayList<AIProvider>();
        this.primaryProvider = provider;
        this.fallbackEnabled = false;
        if (provider != null) {
            this.providers.add(provider);
        }
    }

    public ProviderManager(Nexvor plugin, AIProvider primary, AIProvider fallback, boolean fallbackEnabled) {
        this.plugin = plugin;
        this.providers = new ArrayList<AIProvider>();
        this.primaryProvider = primary;
        this.fallbackProvider = fallback;
        this.fallbackEnabled = fallbackEnabled;
        if (primary != null) {
            this.providers.add(primary);
        }
        if (fallback != null) {
            this.providers.add(fallback);
        }
    }

    public CompletableFuture<ChatResponse> sendRequest(ChatRequest request) {
        if (this.primaryProvider == null) {
            return CompletableFuture.completedFuture(ChatResponse.error("No AI provider configured. Please check your config.yml"));
        }
        return ((CompletableFuture)this.primaryProvider.sendRequest(request).thenCompose(response -> {
            if (response.isSuccess()) {
                return CompletableFuture.completedFuture(response);
            }
            if (this.fallbackEnabled && this.fallbackProvider != null) {
                this.plugin.getNexvorLogger().warn("Primary provider (" + this.primaryProvider.getProviderName() + ") failed, trying fallback (" + this.fallbackProvider.getProviderName() + ")");
                return this.fallbackProvider.sendRequest(request).thenApply(fallbackResponse -> {
                    if (fallbackResponse.isSuccess()) {
                        this.plugin.getNexvorLogger().info("Fallback provider succeeded");
                    } else {
                        this.plugin.getNexvorLogger().warn("Both primary and fallback providers failed!");
                    }
                    return fallbackResponse;
                });
            }
            return CompletableFuture.completedFuture(response);
        })).exceptionally(throwable -> {
            this.plugin.getNexvorLogger().warn("Provider request failed: " + throwable.getMessage());
            return ChatResponse.error("AI provider error: " + throwable.getMessage());
        });
    }

    public AIProvider getPrimaryProvider() {
        return this.primaryProvider;
    }

    public AIProvider getFallbackProvider() {
        return this.fallbackProvider;
    }

    public boolean isFallbackEnabled() {
        return this.fallbackEnabled && this.fallbackProvider != null;
    }

    public List<AIProvider> getAllProviders() {
        return new ArrayList<AIProvider>(this.providers);
    }

    public int getProviderCount() {
        return this.providers.size();
    }

    public boolean hasProvider() {
        return this.primaryProvider != null && this.primaryProvider.isConfigured();
    }

    public void shutdown() {
        for (AIProvider provider : this.providers) {
            try {
                if (provider instanceof GroqProvider) {
                    ((GroqProvider)provider).shutdown();
                    continue;
                }
                if (provider instanceof OpenAIProvider) {
                    ((OpenAIProvider)provider).shutdown();
                    continue;
                }
                if (!(provider instanceof CustomProvider)) continue;
                ((CustomProvider)provider).shutdown();
            }
            catch (Exception e) {
                this.plugin.getNexvorLogger().warn("Error shutting down provider " + provider.getProviderName() + ": " + e.getMessage());
            }
        }
        this.providers.clear();
    }

    public String getSummary() {
        if (this.primaryProvider == null) {
            return "No providers configured";
        }
        StringBuilder summary = new StringBuilder();
        summary.append("Primary: ").append(this.primaryProvider.getProviderName()).append(" (").append(this.primaryProvider.getDefaultModel()).append(")");
        if (this.fallbackProvider != null) {
            summary.append(", Fallback: ").append(this.fallbackProvider.getProviderName()).append(" (").append(this.fallbackProvider.getDefaultModel()).append(")");
            if (this.fallbackEnabled) {
                summary.append(" [ENABLED]");
            } else {
                summary.append(" [DISABLED]");
            }
        }
        return summary.toString();
    }
}

