/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor.ai;

import com.nexvor.Nexvor;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class APIClient {
    private final Nexvor plugin;
    private final HttpClient client;

    public APIClient(Nexvor plugin) {
        this.plugin = plugin;
        this.client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(10L)).build();
    }

    public CompletableFuture<String> postAsync(String url, String json, String authToken) {
        try {
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(30L)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(json));
            if (authToken != null && !authToken.isEmpty()) {
                requestBuilder.header("Authorization", "Bearer " + authToken);
            }
            HttpRequest request = requestBuilder.build();
            return ((CompletableFuture)this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
                if (response.statusCode() >= 200 && response.statusCode() < 300) {
                    return (String)response.body();
                }
                String errorBody = (String)response.body();
                this.plugin.getNexvorLogger().warn("API returned error " + response.statusCode() + ": " + errorBody);
                throw new RuntimeException("API error " + response.statusCode() + ": " + errorBody);
            })).exceptionally(throwable -> {
                this.plugin.getNexvorLogger().error("API request failed: " + throwable.getMessage(), (Throwable)throwable);
                throw new RuntimeException((Throwable)throwable);
            });
        }
        catch (Exception e) {
            this.plugin.getNexvorLogger().error("Failed to create API request: " + e.getMessage(), e);
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<String> postAsync(String url, String json, String authToken, Map<String, String> customHeaders) {
        try {
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(30L)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(json));
            if (authToken != null && !authToken.isEmpty()) {
                requestBuilder.header("Authorization", "Bearer " + authToken);
            }
            if (customHeaders != null && !customHeaders.isEmpty()) {
                for (Map.Entry<String, String> header : customHeaders.entrySet()) {
                    requestBuilder.header(header.getKey(), header.getValue());
                }
            }
            HttpRequest request = requestBuilder.build();
            return ((CompletableFuture)this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
                if (response.statusCode() >= 200 && response.statusCode() < 300) {
                    return (String)response.body();
                }
                String errorBody = (String)response.body();
                this.plugin.getNexvorLogger().warn("API returned error " + response.statusCode() + ": " + errorBody);
                throw new RuntimeException("API error " + response.statusCode() + ": " + errorBody);
            })).exceptionally(throwable -> {
                this.plugin.getNexvorLogger().error("API request failed: " + throwable.getMessage(), (Throwable)throwable);
                throw new RuntimeException((Throwable)throwable);
            });
        }
        catch (Exception e) {
            this.plugin.getNexvorLogger().error("Failed to create API request: " + e.getMessage(), e);
            return CompletableFuture.failedFuture(e);
        }
    }

    public void shutdown() {
        this.plugin.getNexvorLogger().debug("HttpClient shutdown requested (no action needed)");
    }
}

