/*
 * Decompiled with CFR 0.152.
 */
package com.nexvor;

import com.nexvor.ai.AIProvider;
import com.nexvor.ai.ProviderFactory;
import com.nexvor.ai.ProviderManager;
import com.nexvor.commands.NexvorCommand;
import com.nexvor.config.ConfigManager;
import com.nexvor.core.LicenseManager;
import com.nexvor.core.NexvorLogger;
import com.nexvor.core.PluginTier;
import com.nexvor.core.ServerInfo;
import com.nexvor.filter.LanguageFilter;
import com.nexvor.integrations.IntegrationManager;
import com.nexvor.listeners.ChatEventListener;
import com.nexvor.listeners.EventAwarenessListener;
import com.nexvor.memory.ConversationManager;
import com.nexvor.memory.DatabaseManager;
import com.nexvor.memory.GlobalChatManager;
import com.nexvor.memory.GroupConversationManager;
import com.nexvor.memory.ProximityChatManager;
import com.nexvor.ratelimit.RateLimitManager;
import com.nexvor.updater.UpdateChecker;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Nexvor
extends JavaPlugin {
    private static Nexvor instance;
    private ConfigManager configManager;
    private NexvorLogger nexvorLogger;
    private LicenseManager licenseManager;
    private ServerInfo serverInfo;
    private PluginTier activeTier;
    private ProviderManager providerManager;
    private NexvorCommand commandHandler;
    private DatabaseManager databaseManager;
    private ConversationManager conversationManager;
    private GroupConversationManager groupConversationManager;
    private GlobalChatManager globalChatManager;
    private ProximityChatManager proximityChatManager;
    private RateLimitManager rateLimitManager;
    private LanguageFilter languageFilter;
    private IntegrationManager integrationManager;
    private UpdateChecker updateChecker;

    public void onEnable() {
        String mode;
        instance = this;
        this.nexvorLogger = new NexvorLogger(this);
        this.nexvorLogger.info("========================================");
        this.nexvorLogger.info("  Nexvor AI Chatbot");
        this.nexvorLogger.info("  Version: " + this.getDescription().getVersion());
        this.nexvorLogger.info("========================================");
        this.saveDefaultConfig();
        try {
            this.configManager = new ConfigManager(this);
            this.nexvorLogger.info("Configuration loaded successfully");
        }
        catch (Exception e) {
            this.nexvorLogger.severe("Failed to load configuration: " + e.getMessage());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.serverInfo = new ServerInfo(this);
        this.serverInfo.initialize();
        this.nexvorLogger.debug("Server UUID: " + this.serverInfo.getServerUuid());
        this.licenseManager = new LicenseManager(this);
        this.activeTier = this.licenseManager.validateLicense(this.configManager.getLicenseKey(), this.configManager.getLicenseValidationUrl(), this.configManager.getLicenseActivationUrl(), this.serverInfo);
        if (this.activeTier == PluginTier.BASIC) {
            this.nexvorLogger.info("Running in FREE tier - Basic features available");
            this.nexvorLogger.info("Want more features? Visit: https://nexvor.dev/upgrade");
        } else {
            this.nexvorLogger.info("Thank you for supporting Nexvor! " + this.activeTier.getDisplayName() + " tier activated");
            if (this.licenseManager.isOnlineValidation()) {
                this.nexvorLogger.info("License verified online");
            } else {
                this.nexvorLogger.warn("License verified offline - some features may be limited");
            }
        }
        ProviderFactory providerFactory = new ProviderFactory(this);
        this.providerManager = providerFactory.createProviderManager();
        if (this.providerManager == null || !this.providerManager.hasProvider()) {
            this.nexvorLogger.warn("AI provider not initialized! Commands will not work.");
            this.nexvorLogger.warn("Please configure your API key in config.yml");
        } else {
            this.nexvorLogger.info("Provider setup: " + this.providerManager.getSummary());
        }
        this.databaseManager = new DatabaseManager(this);
        this.databaseManager.initialize();
        this.nexvorLogger.info("Database initialized");
        this.conversationManager = new ConversationManager(this, this.databaseManager);
        this.nexvorLogger.info("Conversation manager initialized");
        if (this.hasTier(PluginTier.MEDIUM) && this.configManager.isGroupConversationsEnabled()) {
            switch (mode = this.configManager.getGroupConversationMode()) {
                case "private": {
                    this.groupConversationManager = new GroupConversationManager(this, this.databaseManager);
                    this.nexvorLogger.info("Group conversation manager initialized (private mode)");
                    break;
                }
                case "global": {
                    this.globalChatManager = new GlobalChatManager(this, this.databaseManager);
                    this.nexvorLogger.info("Global chat manager initialized (global mode)");
                    break;
                }
                case "proximity": {
                    this.proximityChatManager = new ProximityChatManager(this, this.databaseManager);
                    this.proximityChatManager.startUpdateTask();
                    this.nexvorLogger.info("Proximity chat manager initialized (proximity mode)");
                    break;
                }
                default: {
                    this.nexvorLogger.warn("Unknown group conversation mode: " + mode + ", defaulting to private");
                    this.groupConversationManager = new GroupConversationManager(this, this.databaseManager);
                }
            }
        }
        this.rateLimitManager = new RateLimitManager(this);
        this.nexvorLogger.info("Rate limit manager initialized");
        this.languageFilter = new LanguageFilter(this);
        this.nexvorLogger.info("Language filter initialized");
        this.integrationManager = new IntegrationManager(this);
        this.integrationManager.initialize();
        if (this.hasTier(PluginTier.MEDIUM) && this.configManager.isGroupConversationsEnabled() && ((mode = this.configManager.getGroupConversationMode()).equals("global") || mode.equals("proximity"))) {
            this.getServer().getPluginManager().registerEvents((Listener)new ChatEventListener(this), (Plugin)this);
            this.nexvorLogger.info("Chat event listener registered");
        }
        if (this.hasTier(PluginTier.MEDIUM) && this.getConfig().getBoolean("event_awareness.enabled", true)) {
            this.getServer().getPluginManager().registerEvents((Listener)new EventAwarenessListener(this), (Plugin)this);
            this.nexvorLogger.info("Event awareness listener registered");
        }
        if (this.configManager.isUpdateCheckEnabled()) {
            this.updateChecker = new UpdateChecker(this, this.configManager.getUpdateUrl());
            this.nexvorLogger.info("Update checker initialized");
            this.updateChecker.checkForUpdatesAsync();
        }
        this.commandHandler = new NexvorCommand(this);
        this.getCommand("nexvor").setExecutor((CommandExecutor)this.commandHandler);
        this.getCommand("nexvor").setTabCompleter((TabCompleter)this.commandHandler);
        this.nexvorLogger.info("Commands registered");
        this.initializeFeatures();
        this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
            if (this.rateLimitManager != null) {
                this.rateLimitManager.cleanup();
            }
        }, 6000L, 6000L);
        if (this.updateChecker != null) {
            this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
                if (this.updateChecker != null) {
                    this.updateChecker.performPeriodicCheck();
                }
            }, 864000L, 864000L);
        }
        this.nexvorLogger.info("Nexvor enabled successfully!");
        this.nexvorLogger.info("========================================");
    }

    public void onDisable() {
        this.nexvorLogger.info("Shutting down Nexvor...");
        if (this.updateChecker != null) {
            this.updateChecker.shutdown();
        }
        if (this.licenseManager != null) {
            this.licenseManager.shutdown();
        }
        if (this.providerManager != null) {
            this.providerManager.shutdown();
        }
        if (this.databaseManager != null) {
            this.databaseManager.close();
        }
        this.nexvorLogger.info("Nexvor disabled successfully!");
    }

    public static Nexvor getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public NexvorLogger getNexvorLogger() {
        return this.nexvorLogger;
    }

    private void initializeFeatures() {
        this.nexvorLogger.info("Loading Basic tier features...");
        if (this.licenseManager.hasTier(PluginTier.MEDIUM)) {
            this.nexvorLogger.info("Loading Medium tier features...");
        }
        if (this.licenseManager.hasTier(PluginTier.MAX)) {
            this.nexvorLogger.info("Loading Max tier features...");
        }
    }

    public LicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public PluginTier getActiveTier() {
        return this.activeTier;
    }

    public boolean hasTier(PluginTier tier) {
        return this.licenseManager.hasTier(tier);
    }

    public AIProvider getAIProvider() {
        return this.providerManager != null ? this.providerManager.getPrimaryProvider() : null;
    }

    public ProviderManager getProviderManager() {
        return this.providerManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public ConversationManager getConversationManager() {
        return this.conversationManager;
    }

    public GroupConversationManager getGroupConversationManager() {
        return this.groupConversationManager;
    }

    public GlobalChatManager getGlobalChatManager() {
        return this.globalChatManager;
    }

    public ProximityChatManager getProximityChatManager() {
        return this.proximityChatManager;
    }

    public RateLimitManager getRateLimitManager() {
        return this.rateLimitManager;
    }

    public LanguageFilter getLanguageFilter() {
        return this.languageFilter;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public void reload() {
        this.reloadConfig();
        this.configManager = new ConfigManager(this);
        this.activeTier = this.licenseManager.revalidate(this.configManager.getLicenseValidationUrl(), this.configManager.getLicenseActivationUrl(), this.serverInfo);
        ProviderFactory providerFactory = new ProviderFactory(this);
        if (this.providerManager != null) {
            this.providerManager.shutdown();
        }
        this.providerManager = providerFactory.createProviderManager();
        this.nexvorLogger.info("Configuration reloaded successfully");
        this.nexvorLogger.info("Active tier: " + this.activeTier.getDisplayName());
        if (this.providerManager != null) {
            this.nexvorLogger.info("Provider setup: " + this.providerManager.getSummary());
        }
    }
}

